unit unumbrix;

interface

uses
  Windows, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, StdCtrls, ComCtrls, Buttons;

type
  Tfnumbrix = class(TForm)
    Panel2: TPanel;
    Panel1: TPanel;
    Panel3: TPanel;
    PBox1: TPaintBox;
    Memo1: TMemo;
    D1: TButton;
    MM1: TMainMenu;
    M2: TMenuItem;
    M1: TMenuItem;
    M3: TMenuItem;
    CB1: TCheckBox;
    ListBox2: TListBox;
    Button2: TButton;
    procedure CloseClick(Sender: TObject);
    procedure PBox1Paint(Sender: TObject);
    procedure PBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure D1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    grad:integer;
    sizex,sizesqr:integer;
    board:array of array of integer;
    location:array of tpoint;
    count:int64; {loop count}
    procedure Newboard;
    procedure resetboard;
    function placenext(next,nextx,nexty:integer):boolean;
    procedure PathBtnClick(Sender: TObject);
     { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  fnumbrix: Tfnumbrix;

implementation

{$R *.DFM}
const fbreite:integer=80;
      schriftgroesse:integer=34;
var lfeld,lfeld2,loesung,lfeldh:array[0..10,0..10] of integer;
    liste:array[0..100] of boolean;
    altenummer,aufgabennr:integer;
    hilfe:boolean;
    inarbeit:boolean;

type TOffset=array[1..4] of TPoint;
var
  maxloop1:integer=100000; {try 100,000 moves before giving up}
  offset:TOffset =((x:0;y:-1),(x:+1;y:0),
                                 (x:0;y:+1), (x:-1;y:0));
  offsets:array[0..23] of TOffset;
  permutes:array[0..23] of array[1..4] of integer=
         ((1,2,3,4),(1,2,4,3),(1,3,2,4),(1,3,4,2),(1,4,2,3),(1,4,3,2),
          (2,1,3,4),(2,1,4,3),(2,3,1,4),(2,3,4,1),(2,4,1,3),(2,4,3,1),
          (3,1,2,4),(3,1,4,2),(3,2,1,4),(3,2,4,1),(3,4,1,2),(3,4,2,1),
          (4,1,2,3),(4,1,3,2),(4,2,1,3),(4,2,3,1),(4,3,1,2),(4,3,2,1));

procedure Tfnumbrix.CloseClick(Sender: TObject);
begin
   close;
end;

procedure Tfnumbrix.PBox1Paint(Sender: TObject);
var breite,hoehe,i,j,xoffset,yoffset:integer;
    bitmap:tbitmap;
    ziel:tcanvas;
    kk,k:string;
    geschafft:boolean;
    ergebnis:integer;
    a,b,suche:integer;
    weiter:boolean;
begin
    hilfe:=cb1.checked;
    breite:=PBox1.width;
    hoehe:=PBox1.height;

    fbreite:=(hoehe-60) div grad;
    if (breite-60) div grad<fbreite then fbreite:=(breite-60) div grad;
    schriftgroesse:=round(fbreite/2.5);
    if grad=10 then dec(schriftgroesse);

    bitmap:=tbitmap.create;
    bitmap.width:=PBox1.width;
    bitmap.height:=PBox1.height;
    ziel:=bitmap.canvas;

    xoffset:=(breite-(grad*fbreite)) div 2;
    yoffset:=(hoehe-(grad*fbreite)) div 2-5;

    ziel.font.name:='Verdana';
    for i:=0 to grad-1 do
      for j:=0 to grad-1 do
      begin
        ziel.brush.color:=clwhite;
        ziel.pen.color:=clgray;
        if lfeld2[i+1,j+1]>0 then ziel.Brush.Color:=$f0f0f0;
        ziel.rectangle(xoffset+i*fbreite,yoffset+j*fbreite,
                    xoffset+i*fbreite+fbreite+1,yoffset+j*fbreite+fbreite+1);
        ziel.font.size:=schriftgroesse;//36;

          if lfeld2[i+1,j+1]>0 then ziel.font.color:=clblue
                    else ziel.font.color:=clblack;
          k:=inttostr(lfeld[i+1,j+1]);
          if hilfe then
            if (loesung[i+1,j+1]=lfeld[i+1,j+1])
               and (ziel.font.color=clblack) then ziel.brush.color:=clyellow
                                             else ziel.brush.style:=bsclear;
          if k<>'0' then
          ziel.textout(xoffset+i*fbreite+(fbreite div 2)-(ziel.textwidth(k) div 2),
                      yoffset+j*fbreite+(fbreite div 2)-(ziel.textheight(k) div 2),k);
      end;

      ziel.pen.width:=3;
      ziel.pen.color:=clnavy;
      ziel.brush.style:=bsclear;
      ziel.rectangle(xoffset-1,yoffset-1,
                     xoffset+grad*fbreite+2,yoffset+grad*fbreite+2);
      ziel.pen.width:=1;
      pBox1.canvas.draw(0,0,bitmap);
      bitmap.free;

      geschafft:=true;
      a:=0; b:=0;
      for i:=1 to grad do
        for j:=1 to grad do
          if lfeld[i,j]=1 then begin a:=i; b:=j end;
      if a*b>0 then begin
        suche:=2;
        repeat
          weiter:=false;
          if lfeld[a+1,b]=suche then begin inc(a); inc(suche); weiter:=true; end;
          if lfeld[a-1,b]=suche then begin dec(a); inc(suche); weiter:=true; end;
          if lfeld[a,b+1]=suche then begin inc(b); inc(suche); weiter:=true; end;
          if lfeld[a,b-1]=suche then begin dec(b); inc(suche); weiter:=true; end;
        until (suche>grad*grad) or (not weiter);
        if suche>grad*grad then
        showmessage('Gratulation! Aufgabe wurde erfolgreich gelst!');
      end;
end;

procedure Tfnumbrix.PBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var b,h,xoffset,yoffset,wert,wert2,nrx,nry:integer;
begin
    b:=PBox1.width;
    h:=PBox1.height;
    xoffset:=(b-(grad*fbreite)) div 2;
    yoffset:=(h-(grad*fbreite)) div 2-5;

    nrx:=(x-xoffset) div fbreite +1;
    nry:=(y-yoffset) div fbreite +1;
    if (nrx>0) and (nrx<=grad) and (nry>0) and (nry<=grad) then
    begin
      if button=mbright then begin
        wert:=lfeld[nrx,nry];
        lfeld[nrx,nry]:=0;
        liste[wert]:=false;
        pbox1Paint(Sender);
        exit
      end;

      if (lfeld2[nrx,nry]=0) then
      begin
        wert:=lfeld[nrx,nry];
        wert2:=wert;
        if wert2=0 then inc(wert2);
        while liste[wert2] do begin
          inc(wert2);
        end;
        if wert2>grad*grad then wert2:=0;
        liste[wert]:=false;
        liste[wert2]:=true;
        lfeld[nrx,nry]:=wert2;
      end;
    end;
    pbox1Paint(Sender);
end;

procedure Tfnumbrix.D1Click(Sender: TObject);
var i,j,anz:integer;
    ok:boolean;
begin
    anz:=0;
    for i:=1 to grad do
      for j:=1 to grad do
      begin
        if (lfeld[i,j]=0) and (loesung[i,j]<>lfeld[i,j]) then inc(anz);
      end;
    if anz>1 then
    begin
      ok:=false;
      repeat
        i:=random(grad)+1;
        j:=random(grad)+1;
        if (lfeld[i,j]=0) and (loesung[i,j]<>lfeld[i,j]) then
        begin
          lfeld[i,j]:=loesung[i,j];
          liste[lfeld[i,j]]:=true;
          ok:=true;
        end;
      until ok;
    end;
    pbox1Paint(Sender);
end;

procedure TFnumbrix.Newboard;
var
  i,j:integer;
begin
  randomize;
  for i:=0 to 23 do
  for j:=1 to 4 do
  offsets[i,j]:=offset[permutes[i,j]];
  sizesqr:=sizex*sizex;
  resetboard;
end;

procedure TFnumbrix.resetboard;
var
  i,j:integer;
begin
  setlength(board,sizex+2,sizex+2);
  for i:=1 to sizex do
  for j:=1 to sizex do board[i,j]:=0;
  for i:=0 to high(board) do
  begin
    board[0,i]:=100;
    board[high(board),i]:=100;
    board[i,0]:=100;
    board[i,high(board)]:=100;
  end;
  setlength(location,sizesqr+1);
  for i:=1 to sizesqr do location[i]:=point(0,0);
end;

var r:integer=0;

{************ Placenext *********}
function TFnumbrix.placenext(next,nextx,nexty:integer):boolean;

  {------------ Neighborcount ---------}
  function neighborcount(nx,ny:integer):integer;
  var
    i:integer;
  begin
    result:=0;
    for i:=1 to 4 do
    with offset[i] do
    if ( board[nx+x, ny+y])>0 then inc(result);
  end;

  {------------ ChangeHoleNbr -----------}
  procedure changeholenbr(const from,too:integer);
  var
    i,j:integer;
  begin
    for i:=1 to sizex do
    for j:=1 to sizex do
    if board[i,j]=from then board[i,j]:=too;
  end;


  {{--------- HoleCount ----------}
  function holecount:integer;
  {count "holes", non connected chains of enpty cells, on the board}
  var
    i,j,k:integer;
    minholenbr:integer;
    n:integer;
  begin
    result:=0;
    for i:=1 to sizex do
    for j:=1 to sizex do   {clear out previous hole ids}
    if board[i,j]<0 then board[i,j]:=0;

    for i:=1 to sizex do
    for j:=1 to sizex do
    if board[i,j]=0 then
    begin
      minHoleNbr:=-100;
      for k:=1 to 4 do {check for empty neighbors already assigned to a hole}
      with offset[k] do
      begin
        n:=board[i+x,j+y];
        {find the smallest hole nbr and asign that to all empty neighbors}
        if (n<0) and (n>minHoleNbr) then minHoleNbr:=n;
      end;
      if minholenbr=-100 then
      begin
        inc(result);
        minholenbr:=-result;
      end;
      board[i,j]:=minHolenbr;
      for k:=1 to 4 do {combine newly connected holes into one (minholenbr)}
      with offset[k] do
      begin
        n:=board[i+x,j+y];
        if n=0 then board[i+x,j+y]:=minholenbr
        else if (n<0) and (n<>minholenbr) then
        begin
          changeholenbr(n,minholenbr);
          dec(result);
        end;
      end;
    end;
  end; {holecount}

  {---------- validmove ----------}
  function validmove(const nxx,x,nyy,y:integer):boolean;
  var
    i,n:integer;
    nx,ny:integer;
  begin
    {if any empty neighbor of the move we are considering would be left with 4
     neighbors (test for 3  neighbors since we haven't made the move yet}
    result:=true;
    nx:=nxx+x; ny:=nyy+y;
    if (next>=sizesqr-2) then  exit;
    for i:=1 to 4 do
    with offset[i] do
    if (board[nx+x, ny+y]<=0)and (neighborcount(nx+x, ny+y) =3)
     then
    begin
      result:=false;
      break;
    end;
    if true{checkholecount.checked} then
    {if the current move would divide the board into two segments then a path
     can never be completed so return false}
    If result then
    begin
      if ((nxx=2) and (x=-1))
      or ((nxx=sizex-1) and (x=1))
      or ((nyy=2) and (y=-1))
      or ((nyy=sizex-1) and (y=1))
      then {we are joining an edge, count holes}
      begin
        {make the move temporarily}
        board[nx,ny]:=next+1;
        n:=HoleCount;
        result:=n<=1;
        board[nx,ny]:=0;
      end;
    end;

  end; {validmove}

var
  i:integer;
begin   {placenext}
  inc(count);
  result:=false;

  if (count>maxloop1) or (tag>0) then exit;
  {check for stop btn click or other messages waiting}
  if (count and $FFFF)=0 then application.processmessages;

  location[next]:=point(nextx,nexty); {save the next path location}
  board[nextx,nexty]:=next;  {set location occupied}
  if next=sizesqr then result:=true  {done}
  else
  begin
    r:=random(24);
    for i:=1 to 4 do
    begin
      with offsets[r,i] do
      if (board[nextx+x,nexty+y]<=0) {location is available}
      and validmove(nextx,x,nexty,y)
      then
      begin
        result:=placenext(next+1,nextx+x, nexty+y);
        if result then exit;
      end;
    end;
    location[next]:=point(0,0);
    board[nextx,nexty]:=0;  {set location as empty}
  end;
end;

procedure TFnumbrix.PathBtnClick(Sender: TObject);
var
  startx,starty:integer;
  i,j:integer;
  OK:boolean;
  s:string;
    procedure makestart(var startx, starty:integer);
    begin
      startx:=random(sizex)+1;
      starty:=random(sizex)+1;
    end;

begin
  listbox2.Clear;
  newboard;
  tag:=0;
  repeat
    count:=0;
    makestart(startx,starty);
    ok:= placenext(1,startx,starty);
    if ok then
    begin
      for i:=1 to sizex do
        begin
          s:='';
          for j:=1 to sizex do
          begin
            if (i=1) or (i=sizex) or (j=1)  or (j=sizex) then
            s:=s+format('%2d ',[abs(board[i,j])])
            else s:=s+'00 ';
          end;
          listbox2.Items.add(trim(s));
        end;
        for i:=1 to sizex do
        begin
          s:='';
    for j:=1 to sizex do
    begin
      s:=s+format('%2d ',[abs(board[i,j])]);
    end;
    listbox2.Items.add(trim(s));
  end;
    end
  until OK or (tag>0){or (count2>maxloop2)};
end;

procedure Tfnumbrix.Button2Click(Sender: TObject);
var i,j,wert:integer;
    k,k2:string;
procedure wspiegeln;
var i,j:integer;
begin
    lfeldh:=lfeld;
    for i:=1 to grad do
    begin
      for j:=1 to grad do lfeld[j,1+grad-i]:=lfeldh[j,i];
    end;
    lfeldh:=loesung;
    for i:=1 to grad do
    begin
      for j:=1 to grad do loesung[j,1+grad-i]:=lfeldh[j,i];
    end;
end;
procedure sspiegeln;
var i,j:integer;
begin
    lfeldh:=lfeld;
    for i:=1 to grad do
    begin
      for j:=1 to grad do lfeld[1+grad-i,j]:=lfeldh[i,j];
    end;
    lfeldh:=loesung;
    for i:=1 to grad do
    begin
      for j:=1 to grad do loesung[1+grad-i,j]:=lfeldh[i,j];
    end;
end;
procedure diagonal;
var i,j:integer;
begin
    lfeldh:=lfeld;
    for i:=1 to grad do
    begin
      for j:=1 to grad do lfeld[i,j]:=lfeldh[j,i];
    end;
    lfeldh:=loesung;
    for i:=1 to grad do
    begin
      for j:=1 to grad do loesung[i,j]:=lfeldh[j,i];
    end;
end;
begin
    if inarbeit then exit;
      sizex:=random(4)+5;
      PathBtnClick(Sender);
    inarbeit:=true;
    fillchar(loesung,sizeof(loesung),0);
    fillchar(lfeld,sizeof(lfeld),0);
    fillchar(lfeld2,sizeof(lfeld2),0);
    fillchar(liste,sizeof(liste),false);

    aufgabennr:=1;
    grad:=sizex;
    for i:=1 to grad do
    begin
      k:=listbox2.items[i-1];
      while pos('  ',k)>0 do delete(k,pos('  ',k),1);
      for j:=1 to grad do begin
        if pos(' ',k)>0 then begin
          k2:=copy(k,1,pos(' ',k)-1);
          delete(k,1,pos(' ',k));
        end else begin
          k2:=k;
        end;
        wert:=strtoint(k2);
        lfeld[i,j]:=wert;
        if wert>0 then liste[wert]:=true;
      end;
    end;
    for i:=1 to grad do
    begin
      k:=listbox2.items[i-1+grad];
      while pos('  ',k)>0 do delete(k,pos('  ',k),1);
      for j:=1 to grad do begin
        if pos(' ',k)>0 then begin
          k2:=copy(k,1,pos(' ',k)-1);
          delete(k,1,pos(' ',k));
        end else begin
          k2:=k;
        end;
        loesung[i,j]:=strtoint(k2);
      end;
    end;
    if random<0.5 then diagonal;
    if random<0.5 then wspiegeln;
    if random<0.5 then sspiegeln;
    lfeld2:=lfeld;
    inarbeit:=false;
    pBox1paint(sender);
end;

procedure Tfnumbrix.FormShow(Sender: TObject);
begin
    altenummer:=-1;
    grad:=7;
    randomize;
    inarbeit:=false;
    Button2Click(Sender);
end;

end.


