unit ukalender;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
var heute : tdatetime;
    jahr, monat, tag : word;
begin
    stringgrid1.cells[0,0]:='Sonntag';
    stringgrid1.cells[1,0]:='Montag';
    stringgrid1.cells[2,0]:='Dienstag';
    stringgrid1.cells[3,0]:='Mittwoch';
    stringgrid1.cells[4,0]:='Donnerstag';
    stringgrid1.cells[5,0]:='Freitag';
    stringgrid1.cells[6,0]:='Sonnabend';
    heute:=now;
    decodedate(heute, jahr, monat, tag);
    edit1.text:=inttostr(monat);
    edit2.text:=inttostr(jahr);
    button1click(sender);
end;

procedure TForm1.Button1Click(Sender: TObject);
var heute:tdatetime;
    jahr, monat : word;
    i, j, spalte, zeile: integer;
    monatslaenge : integer;
begin
    monat := strtoint(edit1.text);
    jahr := strtoint(edit2.text);
    heute:=encodedate( jahr, monat, 1);
    case monat of
      1,3,5,7,8,10,12 : monatslaenge :=31;
      2 : monatslaenge := 28;
      else monatslaenge := 30;
    end;
    if (monat=2) and (((jahr mod 4 =0) and (not (jahr mod 100 =0))) or (jahr mod 400 =0))
      then monatslaenge:= 29;
       
    spalte:=dayofweek(heute)-1;
    zeile:=1;

    for i:=0 to 6 do
      for j:=1 to 5 do
        stringgrid1.cells[i,j]:=' ';

    for i:=1 to monatslaenge do
    begin
      stringgrid1.cells[spalte,zeile]:=inttostr(i);
      inc(spalte);
      if spalte>6 then begin
         spalte:=0;
         inc(zeile);
      end;
    end;
end;

end.
