unit uescher;

interface

uses
  Windows, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, math, Spin;

type
  TEscherForm1 = class(TForm)
    Panel2: TPanel;
    Panel3: TPanel;
    Label6: TLabel;
    Label8: TLabel;
    Label1: TLabel;
    EscherPanel: TPanel;
    Panel4: TPanel;
    Label7: TLabel;
    Listbox1: TListBox;
    Checkbox1: TCheckBox;
    Paintbox1: TPaintBox;
    Checkbox2: TCheckBox;
    RadioGroup1: TRadioGroup;
    Label5: TLabel;
    SButton1: TSpeedButton;
    SButton2: TSpeedButton;
    Liste2: TListBox;
    Label4: TLabel;
    Label3: TLabel;
    Farbe1: TShape;
    Farbbutton1: TButton;
    Farbbutton2: TButton;
    Farbe2: TShape;
    Farbbutton3: TButton;
    Farbe3: TShape;
    Farbbutton4: TButton;
    Farbe4: TShape;
    ColorDialog1: TColorDialog;
    Label2: TLabel;
    Liste3: TListBox;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SEdit1: TSpinEdit;
    SEdit2: TSpinEdit;
    SEdit3: TSpinEdit;
    procedure Paintbox1Paint(Sender: TObject);
    procedure Paintbox1Paintwmf(can:tcanvas);
    procedure Listbox1Click(Sender: TObject);
    procedure Paintbox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Paintbox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Paintbox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SEdit3Change(Sender: TObject);
    procedure SEdit1Change(Sender: TObject);
    procedure Farbbutton1Click(Sender: TObject);
    procedure Farbbutton2Click(Sender: TObject);
    procedure Farbbutton3Click(Sender: TObject);
    procedure Farbbutton4Click(Sender: TObject);
    procedure SEdit2Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SButton1Click(Sender: TObject);
    procedure SButton2Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
    EscherForm1: TEscherForm1;

implementation

{$R *.DFM}
const
    efaktor: real=1;
    nichtescher:boolean=false;
    emaxpunkte:integer=9;
    emaxpunkted2:integer=4;
    emaxpunkte10:integer=10;
    xfarben:array[0..3] of integer = ($0000f0ff,$00ff9090,$00a0ffa0,$0000ff00);
    polziehen:byte=0;

var
    sin3h,sin3:real;
    escherpoly,escherpoly2:array[0..250] of record x,y:real end;
    eschernr,escherfigur,eschertyp,escherverschiebung:integer;
    versch17x,versch17y,versch17x2,versch17y2:real;

function skalenfarbe(const i,m:integer):integer;
begin
    skalenfarbe:=rgb(255-m*i,255-m*i,m*i)
end;

procedure TEscherForm1.Paintbox1Paint(Sender: TObject);
var bitmap:tbitmap;
begin
    if nichtescher then exit;
    bitmap:=tbitmap.create;
    bitmap.width:=Paintbox1.width;
    bitmap.height:=Paintbox1.height;
    Paintbox1Paintwmf(bitmap.canvas);
    Paintbox1.canvas.draw(0,0,bitmap);
    bitmap.free;
end;

procedure TEscherForm1.Paintbox1Paintwmf(can:tcanvas);
var b,h,i,v:integer;
    aussenx,ausseny:boolean;
    pu:array[0..250] of tpoint;
procedure punktedrehen(dx,dy,wi:real);
var xx,yy,zx,zy:real;
    i:integer;
begin
    for i:=0 to escherfigur do
    begin
      xx:=escherpoly[i].x-dx;
      yy:=escherpoly[i].y-dy;
      zx:=cos(wi)*xx+sin(wi)*yy;
      zy:=-sin(wi)*xx+cos(wi)*yy;
      escherpoly2[i].x:=zx+dx;
      escherpoly2[i].y:=zy+dy;
    end;
end;
procedure punktedrehen2(dx,dy,wi:real);
var xx,yy,zx,zy:real;
    i:integer;
begin
    for i:=0 to escherfigur do
    begin
      xx:=escherpoly2[i].x-dx;
      yy:=escherpoly2[i].y-dy;
      zx:=cos(wi)*xx+sin(wi)*yy;
      zy:=-sin(wi)*xx+cos(wi)*yy;
      escherpoly2[i].x:=zx+dx;
      escherpoly2[i].y:=zy+dy;
    end;
end;
function aussentesty:boolean;
var i:integer;
begin
    for i:=0 to escherfigur do
    begin
      if (pu[i].y>0) and (pu[i].y<Paintbox1.height) then
      begin
        aussentesty:=false;
        exit
      end;
    end;
    aussentesty:=true;
end;
function aussentestx:boolean;
var i:integer;
begin
    for i:=0 to escherfigur do
    begin
      if (pu[i].x>0) and (pu[i].x<Paintbox1.width) then
      begin
        aussentestx:=false;
        exit
      end;
    end;
    aussentestx:=true;
end;
procedure poly(p,q:real);
var i:integer;
begin
    for i:=0 to escherfigur do
    begin
      pu[i].x:=round(b+1.0*efaktor*(escherpoly[i].x+p));
      pu[i].y:=round(h+1.0*efaktor*(escherpoly[i].y+q));
    end;
end;
procedure poly2(p,q:real);
var i:integer;
begin
    for i:=0 to escherfigur do
    begin
      pu[i].x:=round(b+1.0*efaktor*(escherpoly2[i].x+p));
      pu[i].y:=round(h+1.0*efaktor*(escherpoly2[i].y+q));
    end;
end;
procedure farbezeichnen(a,b,c:integer);
begin
    case RadioGroup1.itemindex of
      0 : can.brush.color:=clwhite;
      1 : can.brush.color:=skalenfarbe(a,b);
      2 : can.brush.color:=xfarben[c];
    end;
    can.polygon(slice(pu,escherfigur+1));
end;
procedure parkett11(a,c:integer);
begin
    poly(a*200,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    poly(a*200+300,c*100+50);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,0);
    punktedrehen(-50,0,pi);
    poly2(a*200,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);
    poly2(a*200+300,c*100-50);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,1);
end;
procedure parkett12(a,c,nr:integer);
var sk:real;
begin
    sk:=150;
    if not odd(nr) then
    begin
      poly(a*sk,c*sin3h);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c) mod 20,14,(nr+abs(c)) mod 4);
    end
    else
    begin
      punktedrehen(0,50,pi);
      poly2(a*sk,c*sin3h-sin3h);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c) mod 20,14,(nr+abs(c)) mod 4);
    end;
end;
procedure parkett13(a,c:integer);
var sh,s3,c3:real;
begin
    sh:=sin3h;
    s3:=sh;
    c3:=50;
    poly(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    poly(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    punktedrehen(-50+c3,50-sh,2/3*pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);
    poly2(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);
    punktedrehen(-50+c3,50-sh,-2/3*pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,2);
    poly2(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,2);
end;
procedure parkett14(a,c:integer);
var sh,s3,c3:real;
begin
    sh:=sin3h;
    s3:=sin3h;
    c3:=50;
    poly(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    poly(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);

    punktedrehen(-50+c3,50-sh,2/3*pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);
    poly2(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);

    punktedrehen(-50+c3,50-sh,-2/3*pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,2);
    poly2(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,2);

    punktedrehen(-50,50-sh,pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,2);
    poly2(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,2);

    punktedrehen(-50,50-sh,pi);
    punktedrehen2(-50+c3,50-sh,-2/3*pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);
    poly2(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);

    punktedrehen(-50,50-sh,pi);
    punktedrehen2(-50+c3,50-sh,2/3*pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    poly2(a*100-100-c3,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
end;
procedure parkett15(a,c:integer);
var s3,c3:real;
    i:integer;
begin
    s3:=sin3h;
    c3:=50;
    poly(a*s3,c*c3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c div 4),10,0);
    poly(a*s3-s3,c*c3+3*c3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c div 4),10,0);
    for i:=1 to 5 do
    begin
      punktedrehen(-50+s3,50-c3,i*pi/3);
      poly2(a*s3,c*c3);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c div 4)+1,10,i mod 4);
      poly2(a*s3-s3,c*c3+3*c3);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c div 4)+1,10,i mod 4);
    end;
end;
procedure parkett16(a,c:integer);
var s3,c3,br:real;
    i:integer;
begin
    s3:=sin3h;
    c3:=50;
    br:=sin3h+tan(pi/6)*50;
    poly(a*br,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    poly(a*br-br-50/cos(pi/6),c*100+100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    for i:=1 to 5 do
    begin
      punktedrehen(-50+s3,50-c3,i*pi/3);
      poly2(a*br,c*100);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c)+1,10,i mod 3);
      poly2(a*br-br-50/cos(pi/6),c*100+100);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c)+1,10,i mod 3);
    end;
end;
procedure parkett17(a,c:integer);
var i:integer;
begin
    poly(a*versch17x2-c*versch17x,c*versch17y+a*versch17y2);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    for i:=1 to 5 do
    begin
      punktedrehen(50,50,i*pi/3);
      poly2(a*versch17x2-c*versch17x,c*versch17y+a*versch17y2);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c)+1,10,i mod 3);
    end;
end;
procedure parkett18(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    for i:=1 to 3 do
    begin
      punktedrehen(-50+50*sin(pi/2),50-50*sin(pi/2),-i*pi/2);
      poly2(a*100,c*100);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c)+1,10,i mod 4);
    end;
end;
procedure parkett19(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    for i:=1 to 3 do
    begin
      punktedrehen(50,50,-i*pi/2);
      poly2(a*100,c*100);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c)+1,10,i mod 4);
    end;
end;
procedure parkett20(a,c:integer);
var i:integer;
begin
    poly(a*100-(c div 3)*100,c*100-a*50);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c div 3),10,0);
    for i:=1 to 3 do
    begin
      punktedrehen(50,50,i*pi/2);
      poly2(a*100-(c div 3)*100,c*100-a*50);
      aussenx:=aussenx and aussentestx;
      ausseny:=ausseny and aussentesty;
      farbezeichnen(abs(a)+abs(c div 3)+1,10,i mod 4);
    end;
end;
procedure parkett21(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,0);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=100-escherpoly[i].x;
      escherpoly2[i].y:=escherpoly[i].y;
    end;
    poly2(a*100+100,c*100+50);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);
end;
procedure parkett22(a,c:integer);
var i:integer;
begin
    poly(a*100,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,abs(a+c) mod 4);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=0-escherpoly[i].x;
      escherpoly2[i].y:=escherpoly[i].y;
    end;
    poly2(a*100+150,c*sin3h+sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(a+c)+1) mod 4);
end;
procedure parkett23(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,abs(c) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x;
      escherpoly2[i].y:=-escherpoly[i].y;
    end;
    poly2(a*100+100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
end;
procedure parkett24(a,c:integer);
var i:integer;
begin
    poly(a*100,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,abs(c) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x;
      escherpoly2[i].y:=(50-sin3h)+(50-sin3h-escherpoly[i].y);
    end;
    poly2(a*100+150,c*sin3h+sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
end;
procedure parkett25(a,c:integer);
var sh,s3:real;
    i:integer;
begin
    sh:=sin3h;
    s3:=sin3h;
    poly(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c),10,0);

    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x+50;
      escherpoly2[i].y:=(50-sin3h)+(50-sin3h-escherpoly[i].y)+sin3h;
    end;
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c),10,0);
    punktedrehen(-50,50-sh,pi);
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c)+1,10,1);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly2[i].x+50;
      escherpoly2[i].y:=(50-sin3h)+(50-sin3h-escherpoly2[i].y)+sin3h;
    end;
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c)+1,10,1);
end;
procedure parkett26(a,c:integer);
var sh,s3:real;
    i:integer;
begin
    sh:=sin3h;
    s3:=sin3h;
    poly(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c),10,0);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=-50+(-50-escherpoly[i].x)+50;
      escherpoly2[i].y:=escherpoly[i].y+sin3h;
    end;
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c)+1,10,1);
    punktedrehen(0,50-sh,pi);
    poly2(a*100+50,c*s3+s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c)+1,10,1);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=50+(50-escherpoly2[i].x);
      escherpoly2[i].y:=escherpoly2[i].y;
    end;
    poly2(a*100,c*s3);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c),10,0);
end;
procedure parkett27(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c),10,0);
    punktedrehen(50,0,pi);
    poly2(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c)+1,10,1);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x+250;
      escherpoly2[i].y:=-escherpoly[i].y-50;
    end;
    poly2(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c),10,0);
    punktedrehen2(50,-50,pi);
    poly2(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c)+1,10,1);
end;
procedure parkett28(a,c:integer);
var i:integer;
begin
    poly(a*100,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,abs(a+c) mod 4);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=0-escherpoly[i].x;
      escherpoly2[i].y:=escherpoly[i].y;
    end;
    poly2(a*100+150,c*sin3h+sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(a+c)+1) mod 4);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x;
      escherpoly2[i].y:=(50-sin3h)+(50-sin3h-escherpoly[i].y);
    end;
    poly2(a*100+300,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,(abs(a+c)+2) mod 4);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=-escherpoly2[i].x;
      escherpoly2[i].y:=escherpoly2[i].y;
    end;
    poly2(a*100-150,c*sin3h+sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+3,10,(abs(a+c)+3) mod 4);
end;
procedure parkett29(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,abs(c) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x;
      escherpoly2[i].y:=-escherpoly[i].y;
    end;
    poly2(a*100+100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=-escherpoly2[i].x;
      escherpoly2[i].y:=escherpoly2[i].y;
    end;
    poly2(a*100,c*100+100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=-escherpoly[i].x;
      escherpoly2[i].y:=escherpoly[i].y;
    end;
    poly2(a*100+100,c*100+100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,(abs(c)) mod 2);
end;
procedure parkett30(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,abs(c) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x;
      escherpoly2[i].y:=-escherpoly[i].y;
    end;
    poly2(a*100+100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=-escherpoly2[i].x;
      escherpoly2[i].y:=escherpoly2[i].y;
    end;
    poly2(a*100+100,c*100+100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,(abs(c)) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=-escherpoly[i].x;
      escherpoly2[i].y:=escherpoly[i].y;
    end;
    poly2(a*100,c*100+100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
end;
procedure parkett31(a,c:integer);
var i:integer;
begin
    poly(a*100,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c),10,abs(c) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x;
      escherpoly2[i].y:=(50-sin3h/2)+((50-sin3h/2)-escherpoly[i].y);
    end;
    poly2(a*100+150,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
    punktedrehen(100,50-sin3h,pi);
    poly2(a*100,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 2)+abs(c),10,abs(c) mod 2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly2[i].x;
      escherpoly2[i].y:=(50-3*sin3h/2)+((50-3*sin3h/2)-escherpoly2[i].y);
    end;
    poly2(a*100-150,c*sin3h);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,(abs(c)+1) mod 2);
end;
procedure parkett32(a,c:integer);
var i:integer;
begin
    poly(a*100,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 4+c div 2),12,0);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly[i].x;
      escherpoly2[i].y:=-escherpoly[i].y;
    end;
    poly2(a*100+200,c*100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 4+c div 2+1),12,1);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=50+(50-escherpoly[i].x);
      escherpoly2[i].y:=escherpoly[i].y;
    end;
    poly2(a*100+100,c*100-100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 4+c div 2+2),12,2);
    for i:=0 to escherfigur do
    begin
      escherpoly2[i].x:=escherpoly2[i].x;
      escherpoly2[i].y:=-escherpoly2[i].y;
    end;
    poly2(a*100-100,c*100-100);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a div 4+c div 2+3),12,3);
end;
procedure parkett6(a,c:integer);
var sh:real;
begin
    sh:=sin3h;
    poly(a*100,c*sh);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen((abs(a)+abs(c)),10,0);
    poly(a*100+150,c*sh+sh);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen((abs(a)+abs(c)),10,0);

    punktedrehen(0,50-sh,2*pi/3);
    poly2(a*100,c*sh);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+1,10,1);
    poly2(a*100+150,c*sh+sh);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen((abs(a)+abs(c))+1,10,1);
    punktedrehen(0,50-sh,-2*pi/3);
    poly2(a*100,c*sh);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen(abs(a)+abs(c)+2,10,2);
    poly2(a*100+150,c*sh+sh);
    aussenx:=aussenx and aussentestx;
    ausseny:=ausseny and aussentesty;
    farbezeichnen((abs(a)+abs(c))+2,10,2);
end;
procedure parkett;
var jj,i,a,c,nr:integer;
sk,sh:real;
begin
{$I parkett}
    a:=round(-(2*b div 100)/efaktor)-1;
    while a*50*efaktor<b do
    begin
      c:=round(-(2*h div 100)/efaktor)-1;
      while c*50*efaktor<h do
      begin
        if (eschertyp in [3]) then
        begin
          v:=0;
          if odd(c) then v:=50;
        end;
        poly(a*100+v,c*100);
        case RadioGroup1.itemindex of
          0 : can.brush.color:=clwhite;
          1 : can.brush.color:=skalenfarbe((abs(a)+abs(c)) mod 20,14);
          2 : if eschertyp=3 then
              begin
                if (c+100) mod 4 in [1,2] then
                begin
                  if odd(abs(a+c)) then can.brush.color:=xfarben[0]
                                   else can.brush.color:=xfarben[1];
                end
                else
                begin
                  if odd(abs(a+c)) then can.brush.color:=xfarben[1]
                                   else can.brush.color:=xfarben[0];
                end;
              end
              else can.brush.color:=xfarben[(abs(a+c)) mod 2];
        end;
        can.polygon(slice(pu,escherfigur+1));
        inc(c);
      end;
      inc(a);
    end;
end;
procedure punktx(i:integer);
begin
    can.ellipse(round(b+efaktor*escherpoly[i].x)-4,round(h+efaktor*escherpoly[i].y)-4,
                round(b+efaktor*escherpoly[i].x)+5,round(h+efaktor*escherpoly[i].y)+5);
end;
begin
    b:=Paintbox1.width div 2;
    h:=Paintbox1.height div 2;
    v:=0;
    can.brush.color:=clwhite;
    can.pen.color:=clblack;

    parkett;
   //hauptkachel
    if Checkbox2.checked then
    begin
      can.pen.color:=clnavy;
      can.pen.width:=2;
      can.brush.style:=bsclear;
      poly(0,0);
      can.polygon(slice(pu,escherfigur+1));
      can.pen.width:=1;
    end;

    //punkte
    can.pen.color:=clblack;
    if Checkbox1.checked then
    begin
      can.brush.color:=claqua;
      if not (eschertyp in [9,29,32]) then
        for i:=1 to emaxpunkte do punktx(i);
      if eschertyp in [2,3,4,21,22,23,24,28,30,31] then
        for i:=emaxpunkte+2 to 2*emaxpunkte+1 do punktx(i);
      if eschertyp in [4,8,13,14,16,19,24,25] then
        for i:=2*emaxpunkte+3 to 3*emaxpunkte+2 do punktx(i);
      if eschertyp in [8,22] then
        for i:=4*emaxpunkte+5 to 5*emaxpunkte+4 do punktx(i);
      if eschertyp in [15,18] then
      begin
        for i:=2*emaxpunkte+3 to 2*emaxpunkte+3+emaxpunkted2-1 do punktx(i);
      end;
      if eschertyp in [9] then
      begin
        for i:=1 to emaxpunkted2 do punktx(i);
        for i:=emaxpunkte+2 to emaxpunkte+2+emaxpunkted2-1 do punktx(i);
        for i:=2*emaxpunkte+3 to 2*emaxpunkte+3+emaxpunkted2-1 do punktx(i);
        for i:=3*emaxpunkte+4 to 3*emaxpunkte+4+emaxpunkted2-1 do punktx(i);
      end;
      if eschertyp in [32] then
      begin
        for i:=1 to emaxpunkted2 do punktx(i);
        for i:=emaxpunkte+2 to 2*(emaxpunkte+1)-1 do punktx(i);
        for i:=2*(emaxpunkte+1)+1 to 3*(emaxpunkte+1)-1 do punktx(i);
        for i:=4*(emaxpunkte+1)+1 to 4*(emaxpunkte+1)+emaxpunkted2 do punktx(i);
      end;
      if eschertyp in [29] then
      begin
        for i:=1 to emaxpunkted2 do punktx(i);
        for i:=emaxpunkte+2 to 2*(emaxpunkte+1)-1 do punktx(i);
        for i:=2*emaxpunkte+3 to 2*emaxpunkte+3+emaxpunkted2-1 do punktx(i);
      end;
      if eschertyp in [10] then
      begin
        for i:=emaxpunkte+2 to emaxpunkte+2+emaxpunkted2-1 do punktx(i);
        for i:=3*emaxpunkte+4 to 3*emaxpunkte+4+emaxpunkted2-1 do punktx(i);
      end;
      if eschertyp in [28] then
      begin
        for i:=4*(emaxpunkte+1)+1 to 4*(emaxpunkte+1)+emaxpunkted2 do punktx(i);
        for i:=5*(emaxpunkte+1)+1 to 5*(emaxpunkte+1)+emaxpunkted2 do punktx(i);
      end;
      if eschertyp in [26] then
      begin
        for i:=2*emaxpunkte+3 to 2*emaxpunkte+3+emaxpunkted2-1 do punktx(i);
        for i:=3*emaxpunkte+4 to 3*emaxpunkte+4+emaxpunkted2-1 do punktx(i);
      end;
      if eschertyp in [11,12] then
      begin
        for i:=emaxpunkte+2 to emaxpunkte+2+emaxpunkted2-1 do punktx(i);
        for i:=2*emaxpunkte+3 to 2*emaxpunkte+3+emaxpunkted2-1 do punktx(i);
        for i:=4*emaxpunkte+5 to 4*emaxpunkte+5+emaxpunkted2-1 do punktx(i);
      end;
      if eschertyp in [27] then
      begin
        for i:=emaxpunkte+2 to emaxpunkte+2+emaxpunkted2-1 do punktx(i);
        for i:=3*emaxpunkte+4 to 4*emaxpunkte+3 do punktx(i);
      end;
      if eschertyp in [12] then
      begin
        for i:=5*emaxpunkte+6 to 5*emaxpunkte+6+emaxpunkted2-1 do punktx(i);
      end;
      if eschertyp in [31] then
      begin
        for i:=3*emaxpunkte10+1 to 3*emaxpunkte10+emaxpunkted2 do punktx(i);
      end;
      if eschertyp in [17,20] then
      begin
        for i:=2*emaxpunkte+3 to 2*emaxpunkte+3+emaxpunkted2-1 do punktx(i);
        for i:=3*emaxpunkte+4 to 4*emaxpunkte+3 do punktx(i);
      end;
    end;
end;

procedure TEscherForm1.Listbox1Click(Sender: TObject);
var b,h,sel,h100:integer;
    sh:real;
    p17:array[1..2] of record x,y:real end;
procedure linie(anf:integer; ex,ey:real);
var i:integer;
    ax,ay,diffx,diffy:real;
begin
    anf:=anf*emaxpunkte10;
    ax:=escherpoly[anf].x;
    ay:=escherpoly[anf].y;
    escherpoly[anf+emaxpunkte10].x:=ex;
    escherpoly[anf+emaxpunkte10].y:=ey;
    diffx:=(ex-ax)/emaxpunkte10;
    diffy:=(ey-ay)/emaxpunkte10;
    for i:=1 to emaxpunkte do
    begin
      escherpoly[anf+i].x:=ax+i*diffx;
      escherpoly[anf+i].y:=ay+i*diffy;
    end;
end;
begin
    b:=-50;
    h:=50;
    h100:=h-100;
    sel:=Liste2.items.indexof(Listbox1.items[Listbox1.itemindex])+1;
    eschernr:=0;
    if sel>0 then
    begin
      escherpoly[0].x:=b;
      escherpoly[0].y:=h;
      eschertyp:=sel;
      escherverschiebung:=0;
      case sel of
        1,23,2,5,19,29,30 : begin
                linie(0,100+b,h);
                linie(1,100+b,h100);
                linie(2,b,h100);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
         31 : begin
                linie(0,100+b,h);
                linie(1,100+b+50,h-sin3h);
                linie(2,b+50,h-sin3h);
                linie(3,-100+b+50,h-sin3h);
                linie(4,b,h);
                escherfigur:=5*emaxpunkte10-1;
              end;
      20,27 : begin
                linie(0,100+b,h);
                linie(1,100+b,h-100);
                linie(2,b,h-100);
                linie(3,b-50*sin(pi/2),h-100+50*sin(pi/2));
                linie(4,b,h);
                escherfigur:=5*emaxpunkte10-1;
              end;
         26 : begin
                sh:=sin3h;
                linie(0,b+50,h-sh);
                linie(1,b,h-2*sh);
                linie(2,b-50,h-sh);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
          3 : begin
                escherverschiebung:=50;
                linie(0,100+b,h);
                linie(1,150+b,h100);
                linie(2,b+50,h100);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
         21 : begin
                linie(0,b+100,h+50);
                linie(1,b+200,h);
                linie(2,b+100,h-50);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
      4,7,12,22,24,28 : begin
                sh:=sin3h;
                linie(0,100+b,h);
                linie(1,100+b+50,h-sh);
                linie(2,100+b,h-2*sh);
                linie(3,b,h-2*sh);
                linie(4,b-50,h-sh);
                linie(5,b,h);
                escherfigur:=6*emaxpunkte10-1;
              end;
         32 : begin
                linie(0,100+b,h);
                linie(1,200+b,h);
                linie(2,200+b,h-100);
                linie(3,100+b,h-100);
                linie(4,b,h-100);
                linie(5,b,h);
                escherfigur:=6*emaxpunkte10-1;
              end;
      14,25 : begin
                sh:=sin3h;
                linie(0,b+50,h-sh);
                linie(1,b,h-2*sh);
                linie(2,b,h-sh);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
         15 : begin
                linie(0,b+sin3h,h-50);
                linie(1,b,h-2*50);
                linie(2,b,h);
                escherfigur:=3*emaxpunkte10-1;
              end;
         16 : begin
                linie(0,b+sin3h,h-50);
                linie(1,b,h-100);
                linie(2,b-50*tan(pi/6),h-50);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
         18 : begin
                linie(0,b+50*sin(pi/2),h-50*sin(pi/2));
                linie(1,b,h-100*sin(pi/2));
                linie(2,b,h);
                escherfigur:=3*emaxpunkte10-1;
              end;
         17 : begin
                linie(0,b+100,h);
                linie(1,b+50,h-100*cos(pi/6));
                linie(2,b,h-100);
                linie(3,b-50*tan(pi/6),h-50);
                linie(4,b,h);
                escherfigur:=5*emaxpunkte10-1;
                p17[1].x:=0.5*(escherpoly[3*emaxpunkte10].x-50)
                          -sin3*(escherpoly[3*emaxpunkte10].y-50)+50;
                p17[1].y:=sin3*(escherpoly[3*emaxpunkte10].x-50)
                          +0.5*(escherpoly[3*emaxpunkte10].y-50)+50;
                p17[2].x:=0.5*(escherpoly[0].x-50)+sin3*(escherpoly[0].y-50)+50;
                p17[2].y:=-sin3*(escherpoly[0].x-50)+0.5*(escherpoly[0].y-50)+50;
                versch17x:=abs(p17[1].x-p17[2].x);
                versch17y:=abs(p17[1].y-p17[2].y);
                p17[1].x:=escherpoly[3*emaxpunkte10].x;
                p17[1].y:=escherpoly[3*emaxpunkte10].y;
                p17[2].x:=cos(2*pi/3)*(escherpoly[0].x-50)+sin(2*pi/3)*(escherpoly[0].y-50)+50;
                p17[2].y:=-sin(2*pi/3)*(escherpoly[0].x-50)+cos(2*pi/3)*(escherpoly[0].y-50)+50;
                versch17x2:=abs(p17[1].x-p17[2].x);
                versch17y2:=abs(p17[1].y-p17[2].y);
              end;
       6,13 : begin
                sh:=sin3h;
                linie(0,b+50,h-sh);
                linie(1,b,h-2*sh);
                linie(2,b-50,h-sh);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
          8 : begin
                linie(0,b+100,h);
                linie(1,b+200,h);
                linie(2,b+200-cos(pi/3)*100,h-sin(pi/3)*100);
                linie(3,b+100,h-100*sqrt(3));
                linie(4,b+cos(pi/3)*100,h-sin(pi/3)*100);
                linie(5,b,h);
                escherfigur:=6*emaxpunkte10-1;
              end;
          9 : begin
                linie(0,b+100,h);
                linie(1,b+100,h-100);
                linie(2,b,h-100);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
         10 : begin
                escherverschiebung:=50;
                linie(0,b+100,h);
                linie(1,b+150,h100);
                linie(2,b+50,h100);
                linie(3,b,h);
                escherfigur:=4*emaxpunkte10-1;
              end;
         11 : begin
                escherverschiebung:=50;
                linie(0,b+100,h);
                linie(1,200+b,h-50);
                linie(2,100+b,h100);
                linie(3,b,h100);
                linie(4,b,h);
                escherfigur:=5*emaxpunkte10-1;
              end;
        end;
      end;
      Paintbox1paint(sender);
end;

procedure TEscherForm1.Paintbox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var b,h,i,emax1:integer;
    gefunden,korrekt:boolean;
begin
    b:=Paintbox1.width div 2;
    h:=Paintbox1.height div 2;
    if Paintbox1.canvas.pixels[x,y]=claqua then
    begin
      eschernr:=0;
      gefunden:=false;
      i:=1;
      repeat
        if (abs((x-b)/efaktor-escherpoly[i].x)<5) and (abs((y-h)/efaktor-escherpoly[i].y)<5)
        then begin
          korrekt:=false;
          emax1:=emaxpunkte+1;
          case eschertyp of
           1,5,6,7 : korrekt:=i in [1..emaxpunkte10-1];
           2,3,21,23,30 : korrekt:=i in  [1..emaxpunkte10-1,emaxpunkte10+1..2*emaxpunkte10-1];
           13,14,25,16,19 : korrekt:=i in [1..emaxpunkte10-1,2*emaxpunkte10+1..3*emaxpunkte10-1];
           32 : korrekt:=i in
                [1..emaxpunkted2,emaxpunkte+2..2*emax1-1,
                 2*(emax1)+1..3*(emax1)-1,4*(emax1)+1..4*(emax1)+emaxpunkted2];
           15,18 : korrekt:=i in
                 [1..(emax1)-1,2*(emax1)+1..2*(emax1)+emaxpunkted2];
           27 : korrekt:=i in
                 [1..emaxpunkte,emaxpunkte+2..(emax1)+emaxpunkted2,
                 3*(emax1)+1..4*(emax1)-1];
           4,24 : korrekt:=i in
                [1..emaxpunkte,emaxpunkte+2..2*(emax1)-1,2*(emax1)+1..3*(emax1)-1];
           22 : korrekt:=i in
                [1..emaxpunkte,emaxpunkte+2..2*(emax1)-1,4*(emax1)+1..5*(emax1)-1];
           28 : korrekt:=i in
                [1..emaxpunkte,emaxpunkte+2..2*(emax1)-1,
                4*(emax1)+1..4*(emax1)+emaxpunkted2,5*(emax1)+1..5*(emax1)+emaxpunkted2];
           8 : korrekt:=i in
                [1..emaxpunkte,2*(emax1)+1..3*(emax1)-1,4*(emax1)+1..5*(emax1)-1];
           9 : korrekt:=i in [1..emaxpunkted2,emaxpunkte+2..(emax1)+emaxpunkted2,
                2*(emax1)+1..2*(emax1)+emaxpunkted2,3*(emax1)+1..3*(emax1)+emaxpunkted2];
           29 : korrekt:=i in [1..emaxpunkted2,emaxpunkte+2..2*(emax1)-1,
                 2*(emax1)+1..2*(emax1)+emaxpunkted2];
           10 : korrekt:=i in [1..emaxpunkte,emaxpunkte+2..(emax1)+emaxpunkted2,
                 3*(emax1)+1..3*(emax1)+emaxpunkted2];
           26 : korrekt:=i in [1..emaxpunkte,2*(emax1)+1..2*(emax1)+emaxpunkted2,
                 3*(emax1)+1..3*(emax1)+emaxpunkted2];
           11 : korrekt:=i in [1..emaxpunkte,emaxpunkte+2..(emax1)+emaxpunkted2,
                 2*(emax1)+1..2*(emax1)+emaxpunkted2,4*(emax1)+1..4*(emax1)+emaxpunkted2];
           12 : korrekt:=i in [1..emaxpunkte,emaxpunkte+2..(emax1)+emaxpunkted2,
                 2*(emax1)+1..2*(emax1)+emaxpunkted2,
                 4*(emax1)+1..4*(emax1)+emaxpunkted2,5*(emax1)+1..5*(emax1)+emaxpunkted2];
           17,20 : korrekt:=i in [1..emaxpunkte,2*(emax1)+1..2*(emax1)+emaxpunkted2,
                  3*(emax1)+1..4*(emax1)-1];
           31 : korrekt:=i in [1..emaxpunkte,3*(emax1)+1..3*(emax1)+emaxpunkted2,
                  emaxpunkte+2..2*(emax1)-1];
        end;
        if korrekt then
        begin
          gefunden:=true;
          eschernr:=i;
        end;
      end;
      inc(i);
    until gefunden or (i>escherfigur);
  end;
end;

procedure TEscherForm1.Paintbox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var b,h,i:integer;
    sh:real;
procedure punktdrehen(a,e:integer;dx,dy,wi:real);
var xx,yy,zx,zy:real;
begin
    xx:=escherpoly[e].x-dx;
    yy:=escherpoly[e].y-dy;
    zx:=cos(wi)*xx+sin(wi)*yy;
    zy:=-sin(wi)*xx+cos(wi)*yy;
    escherpoly[a].x:=zx+dx;
    escherpoly[a].y:=zy+dy;
end;
procedure gleitspiegeln(a,e:integer;gx,diff:real);
var xx,yy:real;
begin
    xx:=gx+(gx-escherpoly[e].x);
    yy:=escherpoly[e].y;
    escherpoly[a].x:=xx;
    escherpoly[a].y:=yy-diff;
end;
procedure gleitspiegelnx(a,e:integer;gy,diff:real);
var xx,yy:real;
begin
    yy:=gy+(gy-escherpoly[e].y);
    xx:=escherpoly[e].x;
    escherpoly[a].x:=xx-diff;
    escherpoly[a].y:=yy;
end;
begin
    b:=Paintbox1.width div 2;
    h:=Paintbox1.height div 2;
    if eschernr>0 then
    begin
      escherpoly[eschernr].x:=(x-b)/efaktor;
      escherpoly[eschernr].y:=(y-h)/efaktor;
      case eschertyp of
       1 : begin
             escherpoly[3*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x;
             escherpoly[3*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-100;
           end;
      32 : begin
             if eschernr in [1..emaxpunkted2] then
             begin
               punktdrehen((emaxpunkte+1)-eschernr,eschernr,0,50,pi);
             end;
             if eschernr in [4*(emaxpunkte+1)+1..4*(emaxpunkte+1)+emaxpunkted2] then
             begin
               punktdrehen(9*(emaxpunkte+1)-eschernr,eschernr,0,-50,pi);
             end;
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
             begin
               gleitspiegeln(2*(emaxpunkte+1)+eschernr,eschernr,100,100);
             end;
             if eschernr in [2*(emaxpunkte+1)+1..3*(emaxpunkte+1)-1] then
             begin
               gleitspiegelnx(3*(emaxpunkte+1)+eschernr,eschernr,0,200);
             end;
           end;
      31 : begin
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
             begin
               gleitspiegelnx(3*(emaxpunkte+1)+eschernr,eschernr,50-1/2*sin3h,150);
             end;
             if eschernr in [3*(emaxpunkte+1)+1..3*(emaxpunkte+1)+emaxpunkted2] then
             begin
               punktdrehen(7*(emaxpunkte+1)-eschernr,eschernr,-50,50-sin3h,pi);
             end;
             if eschernr in [1..emaxpunkte10-1] then
             begin
               gleitspiegeln(2*(emaxpunkte+1)+eschernr,eschernr,25,sin3h);
             end;
           end;
      30 : begin
             if eschernr in [1..emaxpunkte10-1] then
             begin
               gleitspiegeln(2*(emaxpunkte+1)+eschernr,eschernr,0,100);
             end;
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
             begin
               gleitspiegelnx(2*(emaxpunkte+1)+eschernr,eschernr,0,100);
             end;
           end;
      28 : begin
             sh:=sin3h;
             if eschernr in [1..emaxpunkte10-1] then
             begin
               escherpoly[4*emaxpunkte10-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[4*emaxpunkte10-eschernr].y:=escherpoly[eschernr].y-2*sh;
             end;
             if eschernr in [emaxpunkte10+1..2*(emaxpunkte+1)-1] then
             begin
               gleitspiegeln(emaxpunkte10+eschernr,eschernr,100-50+25,sh);
             end;
             if eschernr in [4*emaxpunkte10+1..4*emaxpunkte10+emaxpunkted2] then
             begin
               punktdrehen(9*emaxpunkte10-eschernr,eschernr,-75,50-3/2*sh,pi);
             end;
             if eschernr in [5*emaxpunkte10+1..5*emaxpunkte10+emaxpunkted2] then
             begin
               punktdrehen(11*emaxpunkte10-eschernr,eschernr,-75,50-1/2*sh,pi);
             end;
           end;
      25 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
               gleitspiegeln((emaxpunkte+1)+eschernr,eschernr,-25,sh);
             if eschernr in [2*(emaxpunkte+1)+1..3*(emaxpunkte+1)-1] then
               punktdrehen(6*(emaxpunkte+1)-eschernr,eschernr,-50,50-sh,pi);
           end;
      26 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
               gleitspiegeln((emaxpunkte+1)+eschernr,eschernr,-25,sh);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+1+emaxpunkted2-1] then
               punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,-75,50-3/2*sh,pi);
             if eschernr in [3*(emaxpunkte+1)+1..3*(emaxpunkte+1)+1+emaxpunkted2-1] then
               punktdrehen(7*(emaxpunkte+1)-eschernr,eschernr,-75,50-1/2*sh,pi);
           end;
      24 : begin
             sh:=sin3h;
             if eschernr in [1..emaxpunkte10-1] then
             begin
               escherpoly[4*emaxpunkte10-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[4*emaxpunkte10-eschernr].y:=escherpoly[eschernr].y-2*sh;
             end;
             if eschernr in [emaxpunkte10+1..2*(emaxpunkte+1)-1] then
               gleitspiegelnx(4*(emaxpunkte+1)+eschernr,eschernr,50-sh/2,150);
             if eschernr in [2*emaxpunkte10-1..3*emaxpunkte10-1] then
               gleitspiegelnx(2*emaxpunkte10+eschernr,eschernr,50-3/2*sh,150);
           end;
      29 : begin
             if eschernr in [1..emaxpunkted2] then
               punktdrehen(emaxpunkte+1-eschernr,eschernr,0,50,pi);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,0,-50,pi);
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
               gleitspiegelnx(2*(emaxpunkte+1)+eschernr,eschernr,0,100);
           end;
      23 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[3*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[3*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-100;
             end;
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
             gleitspiegelnx(2*(emaxpunkte+1)+eschernr,eschernr,0,100);
           end;
     2,3 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[3*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x+escherverschiebung;
               escherpoly[3*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-100;
             end;
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
             begin
               escherpoly[5*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x-100;
               escherpoly[5*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y;
             end;
           end;
       5 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[2*(emaxpunkte+1)+eschernr].x:=-escherpoly[eschernr].x;
               escherpoly[2*(emaxpunkte+1)+eschernr].y:=-escherpoly[eschernr].y;
               escherpoly[2*(emaxpunkte+1)-eschernr].x:=100-escherpoly[eschernr].y;
               escherpoly[2*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].x;
               escherpoly[4*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].y-100;
               escherpoly[4*(emaxpunkte+1)-eschernr].y:=-escherpoly[eschernr].x;
             end;
           end;
      19 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,50,50,-pi/2);
             if eschernr in [2*(emaxpunkte+1)+1..3*(emaxpunkte+1)-1] then
               punktdrehen(6*(emaxpunkte+1)-eschernr,eschernr,-50,-50,-pi/2);
           end;
      21 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
               gleitspiegeln(3*(emaxpunkte+1)+eschernr,eschernr,0,50);
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
               gleitspiegeln((emaxpunkte+1)+eschernr,eschernr,100,50);
           end;
      20 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,50,50,-pi/2);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,0,-50,pi);
             if eschernr in [3*(emaxpunkte+1)+1..4*(emaxpunkte+1)-1] then
               punktdrehen(8*(emaxpunkte+1)-eschernr,eschernr,-50-50*sin(pi/2),50-50*sin(pi/2),-pi/2);
           end;
      27 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[3*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[3*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-100;
             end;
             if eschernr in [(emaxpunkte+1)+1..(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(3*(emaxpunkte+1)-eschernr,eschernr,50,0,pi);
             if eschernr in [3*(emaxpunkte+1)+1..4*(emaxpunkte+1)-1] then
               gleitspiegeln((emaxpunkte+1)+eschernr,eschernr,-75,-50);
           end;
       4 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[4*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[4*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-2*sh;
             end;
             if eschernr in [(emaxpunkte+1)+1..2*(emaxpunkte+1)-1] then
             begin
               escherpoly[6*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x-150;
               escherpoly[6*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-sin3h;
             end;
             if eschernr in [2*(emaxpunkte+1)-1..3*(emaxpunkte+1)-1] then
             begin
               escherpoly[8*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x-150;
               escherpoly[8*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y+sin3h;
             end;
           end;
      22 : begin
             sh:=sin3h;
             if eschernr in [1..emaxpunkte10-1] then
             begin
               escherpoly[4*emaxpunkte10-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[4*emaxpunkte10-eschernr].y:=escherpoly[eschernr].y-2*sh;
             end;
             if eschernr in [emaxpunkte10+1..2*(emaxpunkte+1)-1] then
             begin
               gleitspiegeln(emaxpunkte10+eschernr,eschernr,100-50+25,sh);
             end;
             if eschernr in [4*emaxpunkte10+1..5*emaxpunkte10-1] then
             begin
               gleitspiegeln(emaxpunkte10+eschernr,eschernr,-50-25,-sh);
             end;
           end;
       6 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,-50+50,50-sh,-2*pi/3);
               punktdrehen(4*(emaxpunkte+1)-eschernr,eschernr,-50,50,pi/3);
               punktdrehen(2*(emaxpunkte+1)+eschernr,2*(emaxpunkte+1)-eschernr,-50,50-2*sh,-pi/3);
             end;
           end;
      13 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,-50+50,50-sh,-2*pi/3);
             end;
             if eschernr in [2*(emaxpunkte+1)+1..3*(emaxpunkte+1)-1] then
             begin
               punktdrehen(6*(emaxpunkte+1)-eschernr,eschernr,-50-50,50-sh,-2*pi/3);
             end;
           end;
       7 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,50,50,-2*pi/3);
               punktdrehen(2*(emaxpunkte+1)+eschernr,2*(emaxpunkte+1)-eschernr,50+50,50-sh,-2*pi/3);
               punktdrehen(6*(emaxpunkte+1)-eschernr,eschernr,-50,50,2*pi/3);
               punktdrehen(4*(emaxpunkte+1)+eschernr,6*(emaxpunkte+1)-eschernr,-50-50,50-sh,2*pi/3);
               escherpoly[4*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[4*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-2*sh;
             end;
           end;
       8 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,50,50,pi);
             if eschernr in [2*(emaxpunkte+1)+1..3*(emaxpunkte+1)-1] then
               punktdrehen(6*(emaxpunkte+1)-eschernr,eschernr,-50+200-50,50-sin3h,pi);
             if eschernr in [4*(emaxpunkte+1)+1..5*(emaxpunkte+1)-1] then
               punktdrehen(10*(emaxpunkte+1)-eschernr,eschernr,-50+50,50-sin3h,pi);
           end;
       9 : begin
             if eschernr in [1..emaxpunkted2] then
               punktdrehen((emaxpunkte+1)-eschernr,eschernr,0,50,pi);
             if eschernr in [(emaxpunkte+1)+1..(emaxpunkte+1)+emaxpunkted2] then
                punktdrehen(3*(emaxpunkte+1)-eschernr,eschernr,50,0,pi);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
                punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,0,-50,pi);
             if eschernr in [3*(emaxpunkte+1)+1..3*(emaxpunkte+1)+emaxpunkted2] then
                punktdrehen(7*(emaxpunkte+1)-eschernr,eschernr,-50,0,pi);
           end;
      18 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,-50+50*sin(pi/2),50-sin(pi/2)*50,-pi/2);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,-50,50-sin(pi/2)*50,pi);
           end;
      10 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[3*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x+escherverschiebung;
               escherpoly[3*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-100;
             end;
             if eschernr in [(emaxpunkte+1)+1..(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(3*(emaxpunkte+1)-eschernr,eschernr,75,0,pi);
             if eschernr in [3*(emaxpunkte+1)+1..3*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(7*(emaxpunkte+1)-eschernr,eschernr,-25,0,pi);
           end;
      14 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,-50+50,50-sh,-2/3*pi);
             if eschernr in [2*(emaxpunkte+1)+1..3*(emaxpunkte+1)-1] then
               punktdrehen(6*(emaxpunkte+1)-eschernr,eschernr,-50,50-sh,pi);
           end;
      15 : begin
             sh:=50;
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,-50+sin3h,50-sh,-pi/3);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,-50,50-sh,pi);
           end;
      16 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,-50+sin3h,50-50,-pi/3);
             if eschernr in [2*(emaxpunkte+1)+1..3*(emaxpunkte+1)-1] then
               punktdrehen(6*(emaxpunkte+1)-eschernr,eschernr,-50-50*tan(pi/6),0,-2/3*pi);
           end;
      17 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
               punktdrehen(2*(emaxpunkte+1)-eschernr,eschernr,50,50,-pi/3);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,-50+50-25,50-100*cos(pi/6)-(100-100*cos(pi/6))/10*5,pi);
             if eschernr in [3*(emaxpunkte+1)+1..4*(emaxpunkte+1)-1] then
               punktdrehen(8*(emaxpunkte+1)-eschernr,eschernr,-50-50*tan(pi/6),0,-2/3*pi);
           end;
      11 : begin
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[4*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[4*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-100;
             end;
             if eschernr in [(emaxpunkte+1)+1..(emaxpunkte+1)+emaxpunkted2] then
                punktdrehen(3*(emaxpunkte+1)-eschernr,eschernr,100,25,pi);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
                punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,100,-25,pi);
             if eschernr in [4*(emaxpunkte+1)+1..4*(emaxpunkte+1)+emaxpunkted2] then
                punktdrehen(9*(emaxpunkte+1)-eschernr,eschernr,-50,0,pi);
           end;
      12 : begin
             sh:=sin3h;
             if eschernr in [1..(emaxpunkte+1)-1] then
             begin
               escherpoly[4*(emaxpunkte+1)-eschernr].x:=escherpoly[eschernr].x;
               escherpoly[4*(emaxpunkte+1)-eschernr].y:=escherpoly[eschernr].y-2*sh;
             end;
             if eschernr in [(emaxpunkte+1)+1..(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(3*(emaxpunkte+1)-eschernr,eschernr,50+25,50-50*sin3,pi);
             if eschernr in [2*(emaxpunkte+1)+1..2*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(5*(emaxpunkte+1)-eschernr,eschernr,50+25,50-150*sin3,pi);
             if eschernr in [4*(emaxpunkte+1)+1..4*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(9*(emaxpunkte+1)-eschernr,eschernr,-50-25,50-150*sin3,pi);
             if eschernr in [5*(emaxpunkte+1)+1..5*(emaxpunkte+1)+emaxpunkted2] then
               punktdrehen(11*(emaxpunkte+1)-eschernr,eschernr,-50-25,50-50*sin3,pi);
           end;
      end;
      Paintbox1paint(sender);
    end;
end;

procedure TEscherForm1.Paintbox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    if eschernr>0 then
    begin
      eschernr:=0;
      Paintbox1paint(sender);
    end;
end;

procedure TEscherForm1.SEdit3Change(Sender: TObject);
begin
    efaktor:=SEdit3.value*0.2;
    Paintbox1paint(sender);
end;

procedure TEscherForm1.SEdit1Change(Sender: TObject);
var i,lnr:integer;
    k:string;
function lesen:integer;
begin
    lesen:=strtoint(Liste3.items[lnr]);
    inc(lnr);
end;
function rlesen:real;
var r:real;
    code:integer;
begin
    val(Liste3.items[lnr],r,code);
    rlesen:=r;
    inc(lnr);
end;
begin
    k:='['+inttostr(round(SEdit1.value));
    lnr:=Liste3.items.indexof(k)+1;
    eschertyp:=lesen;
    nichtescher:=true;
    application.processmessages;
    Liste2.itemindex:=eschertyp-1;
    Listbox1.itemindex:=Listbox1.items.indexof(Liste2.items[Liste2.itemindex]);
    emaxpunkte:=lesen;
    SEdit2.value:=emaxpunkte;
    emaxpunkted2:=emaxpunkte div 2;
    emaxpunkte10:=emaxpunkte+1;
    Listbox1click(sender);
    nichtescher:=false;
    escherfigur:=lesen;
    for i:=0 to escherfigur do
    begin
      escherpoly[i].x:=rlesen;
      escherpoly[i].y:=rlesen;
    end;
    Paintbox1paint(sender);
end;

procedure TEscherForm1.Farbbutton1Click(Sender: TObject);
begin
    if ColorDialog1.execute then
    begin
      xfarben[0]:=ColorDialog1.color;
      Farbe1.Brush.color:=xfarben[0];
      Paintbox1paint(sender);
    end;
end;

procedure TEscherForm1.Farbbutton2Click(Sender: TObject);
begin
    if ColorDialog1.execute then
    begin
      xfarben[1]:=ColorDialog1.color;
      Farbe2.Brush.color:=xfarben[1];
      Paintbox1paint(sender);
    end;
end;

procedure TEscherForm1.Farbbutton3Click(Sender: TObject);
begin
    if ColorDialog1.execute then
    begin
      xfarben[2]:=ColorDialog1.color;
      Farbe3.Brush.color:=xfarben[2];
      Paintbox1paint(sender);
    end;
end;

procedure TEscherForm1.Farbbutton4Click(Sender: TObject);
begin
    if ColorDialog1.execute then
    begin
      xfarben[3]:=ColorDialog1.color;
      Farbe4.Brush.color:=xfarben[3];
      Paintbox1paint(sender);
    end;
end;

procedure TEscherForm1.SEdit2Change(Sender: TObject);
begin
    if SEdit2.value<=SEdit2.minvalue then SEdit2.value:=SEdit2.minvalue;
    emaxpunkte:=round(SEdit2.value);
    emaxpunkted2:=emaxpunkte div 2;
    emaxpunkte10:=emaxpunkte+1;
    Listbox1click(sender);
end;

procedure TEscherForm1.FormActivate(Sender: TObject);
begin
    Listbox1.itemindex:=0;
    emaxpunkte:=round(SEdit2.value);
    emaxpunkted2:=emaxpunkte div 2;
    emaxpunkte10:=emaxpunkte+1;
    efaktor:=1;
    Farbe1.brush.color:=xfarben[0];
    Farbe2.brush.color:=xfarben[1];
    Farbe3.brush.color:=xfarben[2];
    Farbe4.brush.color:=xfarben[3];
    sin3h:=100*sin(pi/3);
    sin3:=sin(pi/3);
    eschernr:=0;
    nichtescher:=false;
    Listbox1click(sender);
end;

procedure TEscherForm1.SButton1Click(Sender: TObject);
var dd:textfile;
    i:integer;
begin
    if OpenDialog1.execute then
    begin
      assignfile(dd,OpenDialog1.FileName);
      reset(dd);
      readln(dd,eschertyp);
      nichtescher:=true;
      Liste2.itemindex:=eschertyp-1;
      Listbox1.itemindex:=Listbox1.items.indexof(Liste2.items[Liste2.itemindex]);
      readln(dd,emaxpunkte);
      SEdit2.value:=emaxpunkte;
      emaxpunkted2:=emaxpunkte div 2;
      emaxpunkte10:=emaxpunkte+1;
      Listbox1click(sender);
      nichtescher:=false;
      readln(dd,escherfigur);
      for i:=0 to escherfigur do
      begin
        readln(dd,escherpoly[i].x);
        readln(dd,escherpoly[i].y);
      end;
      closefile(dd);
      Paintbox1paint(sender);
    end;
end;

procedure TEscherForm1.SButton2Click(Sender: TObject);
var dd:textfile;
    i:integer;
begin
    if SaveDialog1.execute then
    begin
      assignfile(dd,SaveDialog1.FileName);
      rewrite(dd);
      writeln(dd,eschertyp);
      writeln(dd,emaxpunkte);
      writeln(dd,escherfigur);
      for i:=0 to escherfigur do
      begin
        writeln(dd,floattostr(escherpoly[i].x));
        writeln(dd,floattostr(escherpoly[i].y));
      end;
      closefile(dd);
    end;
end;

end.


